/* 
 * Copyright (C) 2006-2021 Registro.br. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY REGISTRO.BR ``AS IS AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIE OF FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL REGISTRO.BR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/* $Id$ */
/** @file DefRegRenewRsp.H
 *  @brief EPP DefRegRenewRsp Class
 */

#ifndef __DEF_REG_RENEW_RSP_H__
#define __DEF_REG_RENEW_RSP_H__

#include <list>
#include <string>

#include "libepp_nicbr.H"

#include "Response.H"

using std::list;
using std::string;

LIBEPP_NICBR_NS_BEGIN

/// EPP DefRegRenewRsp Class
class DefRegRenewRsp : public Response
{
public:
	/// Default constructor
	DefRegRenewRsp(bool reset = true) : Response(false)
	{
		if (reset) {
			this->reset();
		}
	}

	/// Sets repository object identification
	/**
	   @param roid   repository object identification
	*/
	void set_roid(const string& roid) { _roid = roid; }

	/// Returns repository object identification
	/**
	   @return repository object identification
	*/
	string get_roid() const { return _roid; }

	/// Sets expiration date
	/**
	   @param exDate expiration date
	*/
	void set_exDate(const string& exDate) { _exDate = exDate; }

	/// Returns expiration date
	/**
	   @return expiration date
	*/
	string get_exDate() const { return _exDate; }

	/// Resets object attributes
	void reset() 
	{
		Response::reset();
		_roid = "";
		_exDate = "";
	}

protected:
	/// Contains the Repository Object Identifier assigned to the
	/// Defensive Registration object when the object was created
	string _roid;

	/// expiration date
	string _exDate;
};

LIBEPP_NICBR_NS_END

#endif // __DEF_REG_RENEW_RSP_H__
