/* 
 * Copyright (C) 2006-2021 Registro.br. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY REGISTRO.BR ``AS IS AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIE OF FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL REGISTRO.BR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/* $Id$ */
/** @file DefRegRenewCmd.H
 *  @brief EPP DefRegRenewCmd Class
 */

#ifndef __DEF_REG_RENEW_CMD_H__
#define __DEF_REG_RENEW_CMD_H__

#include <string>

#include "libepp_nicbr.H"

#include "Command.H"
#include "RegistrationPeriod.H"

using std::string;

LIBEPP_NICBR_NS_BEGIN

/// EPP DefRegRenewCmd Class
class DefRegRenewCmd : public Command
{
public:
	/// Default constructor
	DefRegRenewCmd(bool reset = true) : Command(false)
	{
		if (reset) {
			this->reset();
		}
	}

	/// Set defensive registration roid
	/**
	   @param roid   identification of a defensive registration
	*/
	void set_roid(const string &roid) { _roid = roid; } 
  
	/// Returns defensive registration roid
	/**
	   @return identification of a defensive registration
	*/
	string get_roid() const { return _roid; }
  
	/// Sets date on which the current validity period ends
	/**
	 * @param date date on which the current validity period ends
	 */
	void set_cur_exp_date(const string &date) { _cur_exp_date = date; }

	/// Returns date on which the current validity period ends
	/**
	 * @return date on which the current validity period ends
	 */
	string get_cur_exp_date() const { return _cur_exp_date; }

	/// Sets number of units to be added to the registration period of
	/// the Defensive Registration object
	/**
	 * @param time   amount of time
	 * @param unit   measure unit
	 */
	void set_period(const int time, const string& unit)
	{
		_period.time = time;
		_period.unit = unit;
	}

	/// Returns number of units to be added to the registration period
	/// of the Defensive Registration object
	/**
	 * @return number of units to be added to the registration period
	 */
	RegistrationPeriod get_period() const { return _period; }

	/// Reset object attributes
	void reset()
	{
		Command::reset();
		_roid.clear();
		_cur_exp_date.clear();
		_period.time = 0;
		_period.unit = "";
	}

protected:
	/// Defensive registration roid
	string _roid;

	/// Date on which the current validity period ends
	string _cur_exp_date;

	/// Number of units to be added to the registration period of the
	/// Defensive Registration object
	RegistrationPeriod _period;
};

LIBEPP_NICBR_NS_END

#endif // __DEF_REG_RENEW_CMD_H__
