/* 
 * Copyright (C) 2006-2021 Registro.br. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY REGISTRO.BR ``AS IS AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIE OF FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL REGISTRO.BR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/* $Id$ */
/** @file DefRegCheckRsp.H
 *  @brief EPP DefRegCheckRsp Class
 */

#ifndef __DEF_REG_CHECK_RSP_H__
#define __DEF_REG_CHECK_RSP_H__

#include <list>
#include <string>

#include "libepp_nicbr.H"

#include "Response.H"
#include "CommonData.H"

using std::list;
using std::string;

LIBEPP_NICBR_NS_BEGIN

/// EPP DefRegCheckRsp Class
class DefRegCheckRsp : public Response
{
public:
	/// EPP NameRsp Class
	class Name : public DefRegName
	{
	public:
		/// Default constructor
		Name() :
			DefRegName(),
			_avail(false),
			_reason("")
		{
		}

		/// Set the object availability
		/*
		  @param avail object availability
		 */
		void set_avail(const bool avail)
		{
			_avail = avail;
		}

		/// Returns object availability
		/*
		  @return object availability
		 */
		bool is_avail() const
		{
			return _avail;
		}

		/// Sets the object unavailability reason
		/*
		  @param reason unavailability reason message
		 */
		void set_reason(const string &reason)
		{
			_reason = reason;
		}

		/// Returns object unavailability reason
		/*
		  @return object unavailability reason
		 */
		string get_reason() const
		{
			return _reason;
		}

	private:
		/// Object availability
		bool _avail;
		/// Reason of an unavailability
		string _reason;
	};

	/// Default constructor
	DefRegCheckRsp(bool reset = true) : Response(false)
	{
		if (reset) {
			this->reset();
		}
	}

	/// Add availability information for a defensive registration name
	/// to the list
	/*
	  @param name name availability
	 */
	void add_name(const Name &name) { _availability_list.push_back(name); }

	/// Returns list of names with their availability
	/*
	  @return list of name with their availability
	 */
	list<Name> get_names() const { return _availability_list; }

	/// Resets object attributes
	void reset() 
	{
		Response::reset();
		_availability_list.clear();
	}

protected:
	/// Defensive registration name list
	list<Name> _availability_list;
};

LIBEPP_NICBR_NS_END

#endif // __DEF_REG_CHECK_RSP_H__
