/* 
 * Copyright (C) 2006-2021 Registro.br. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY REGISTRO.BR ``AS IS AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIE OF FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL REGISTRO.BR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/* $Id$ */
/** @file DefRegCheckCmd.H
 *  @brief EPP DefRegCheckCmd Class
 */

#ifndef __DEF_REG_CHECK_CMD_H__
#define __DEF_REG_CHECK_CMD_H__

#include <string>
#include <set>

#include "libepp_nicbr.H"

#include "Command.H"
#include "CommonData.H"

using std::string;
using std::set;

LIBEPP_NICBR_NS_BEGIN

/// EPP DefRegCheckCmd Class
class DefRegCheckCmd : public Command
{
public:
	/// Default constructor
	DefRegCheckCmd(bool reset = true) : Command(false)
	{
		if (reset) {
			this->reset();
		}
	}

	/// Add a defensive registration name to the list
	/**
	   @param name   name to be added to list
	*/
	void insert_name(const DefRegName &name) { _name_list.insert(name); } 
  
	/// Returns defensive registration name list
	/**
	   @return defensive registration name list
	*/
	set<DefRegName> get_name_list() const { return _name_list; }
  
	/// Reset object attributes
	void reset()
	{
		Command::reset();
		_name_list.clear();
	}

protected:
	/// Defensive registration name list
	set<DefRegName> _name_list;
};

LIBEPP_NICBR_NS_END

#endif // __DEF_REG_CHECK_CMD_H__
