/* 
 * Copyright (C) 2006-2021 Registro.br. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY REGISTRO.BR ``AS IS AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIE OF FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL REGISTRO.BR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/* $Id$ */
/** @file  ClaimsNotice.H
 *  @brief EPP Launch Phase
 */

#ifndef __CLAIMS_NOTICE_H__
#define __CLAIMS_NOTICE_H__

LIBEPP_NICBR_NS_BEGIN

/// EPP Notice Class
class ClaimsNotice
{
public:
	/// Default constructor
	ClaimsNotice()
	{
		reset();
	}

	/// Sets the unique notice identifier generated by the source of the
	/// Claims Notice information
	/**
	 * @param id unique notice identifier generated by the source of the
	 * Claims Notice information
	 */
	void set_id(const string &id) { _id = id; }

	/// Returns the unique notice identifier generated by the source of
	/// the Claims Notice information
	/**
	 * @return unique notice identifier generated by the source of the
	 * Claims Notice information
	 */
	string get_id() const { return _id; }

	/// Sets the expiry of the claims notice
	/**
	 * @param notAfter expiry of the claims notice
	 */
	void set_notAfter(const string &notAfter) { _notAfter = notAfter; }

	/// Returns the expiry of the claims notice
	/**
	 * @return expiry of the claims notice
	 */
	string get_notAfter() const { return _notAfter; }

	/// Sets the date and time that the Claims Notice was accepted
	/**
	 * @param acceptedDate date and time that the Claims Notice was
	 * accepted
	 */
	void set_acceptedDate(const string &acceptedDate) { _acceptedDate = acceptedDate; }

	/// Returns the date and time that the Claims Notice was accepted
	/**
	 * @return date and time that the Claims Notice was accepted
	 */
	string get_acceptedDate() const { return _acceptedDate; }

	/// Returns if the Notice object is empty
	/**
	 * @return true for empty notice object or false otherwise
	 */
	bool is_empty() const
	{
		return _id.empty() && _notAfter.empty() && _acceptedDate.empty();
	}

	/// Reset object attributes
	void reset()
	{
		_id.clear();
		_notAfter.clear();
		_acceptedDate.clear();
	}

private:
	/// Unique notice identifier generated by the source of the Claims
	/// Notice information
	string _id;

	/// Expiry of the claims notice
	string _notAfter;

	/// Contains the date and time that the Claims Notice was accepted
	string _acceptedDate;
};

LIBEPP_NICBR_NS_END

#endif
