/* 
 * Copyright (C) 2006-2021 Registro.br. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 1. Redistribution of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY REGISTRO.BR ``AS IS AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIE OF FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL REGISTRO.BR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/* $Id$ */
/** @file AsnReserveCreateRsp.H
 *  @brief EPP AsnReserveCreateRsp Class
 */

#ifndef __ASNRESERVECREATERSP_H__
#define __ASNRESERVECREATERSP_H__

#include <string>

#include "libepp_nicbr.H"

#include "Response.H"

using std::string;

LIBEPP_NICBR_NS_BEGIN

/// EPP AnsCreateRsp Class
class AsnReserveCreateRsp : public Response
{
public:
	/// Default constructor
	AsnReserveCreateRsp(bool reset = true) : Response(false)
	{
		if (reset) {
			this->reset();
		}
	}
  
	/// Sets asn
	/**
	   @param asn   object id
	*/
	void set_id(const int id)
	{
		_id = id;
	}

	/// Returns object id
	/**
	   @return object id
	*/
	int get_id() const
	{
		return _id;
	}

	/// Sets creation date
	/**
	   @param crDate   object creation date
	*/
	void set_crDate(const string& crDate) { _crDate = crDate; }

	/// Returns creation date
	/**
	   @return creation date
	*/
	string get_crDate() const { return _crDate; }

	void reset()
	{
		Response::reset();
		_id = 0;
		_crDate = "";
	}

protected:
	/// object id of the reservation
	int _id;
  
	/// date and time of object creation
	string _crDate;
};

LIBEPP_NICBR_NS_END
#endif // __ASNRESERVECREATERSP_H__
